/****************************************************************************
 * Ralink Tech Inc.
 * 4F, No. 2 Technology 5th Rd.
 * Science-based Industrial Park
 * Hsin-chu, Taiwan, R.O.C.
 * (c) Copyright 2002, Ralink Technology, Inc.
 *
 * All rights reserved. Ralink's source code is an unpublished work and the
 * use of a copyright notice does not imply otherwise. This source code
 * contains confidential trade secret material of Ralink Tech. Any attemp
 * or participation in deciphering, decoding, reverse engineering or in any
 * way altering the source code is stricitly prohibited, unless the prior
 * written consent of Ralink Technology, Inc. is obtained.
 ****************************************************************************
 
    Module Name:
    ft.c
 
    Abstract:
 
    Revision History:
    Who         When          What
    --------    ----------    ----------------------------------------------
    Fonchi Wu   12-19-2008    
 */
#ifdef DOT11R_FT_SUPPORT

#include "rt_config.h"
#include "ft.h"



/*
========================================================================
Routine Description:

Arguments:

Return Value:

Note:

========================================================================
*/
VOID FT_FillMdIeInfo(
	PEID_STRUCT eid_ptr,
	PFT_MDIE_INFO pMdIeInfo)
{
	PFT_MDIE pMdIe;

	pMdIeInfo->Len = 3;
	pMdIeInfo->pMdIe = eid_ptr;	/* store the pointer of the original MD-IE for MIC calculating */ 

	pMdIe = (PFT_MDIE)(eid_ptr->Octet);
	FT_SET_MDID(pMdIeInfo->MdId, pMdIe->MdId);

	NdisMoveMemory(&(pMdIeInfo->FtCapPlc.word), &pMdIe->FtCapPlc.word,
		sizeof(FT_CAP_AND_POLICY));
}

/*
========================================================================
Routine Description:

Arguments:

Return Value:

Note:

========================================================================
*/
VOID FT_FillFtIeInfo(
	PEID_STRUCT eid_ptr,
	PFT_FTIE_INFO pFtIeInfo)
{
	PFT_FTIE pFtIe;
	PFT_OPTION_FIELD subEidPtr;
	UINT16 MicCtrBuf;
	INT RemainLen;
	PUINT8	ptr;

	RemainLen = eid_ptr->Len;
	pFtIeInfo->Len = eid_ptr->Len;
	pFtIeInfo->pFtIe = eid_ptr;		/* store the pointer of the original FT-IE for MIC calculating */ 

	pFtIe = (PFT_FTIE)eid_ptr->Octet;
	NdisMoveMemory(&MicCtrBuf, &(pFtIe->MICCtr.word),
					sizeof(FT_MIC_CTR_FIELD));
	pFtIeInfo->MICCtr.word = le2cpu16(MicCtrBuf);
	RemainLen -= 2;

	NdisMoveMemory(pFtIeInfo->MIC, pFtIe->MIC, 16);
	RemainLen -= 16;

	NdisMoveMemory(pFtIeInfo->ANonce, pFtIe->ANonce, 32);
	RemainLen -= 32;

	NdisMoveMemory(pFtIeInfo->SNonce, pFtIe->SNonce, 32);
	RemainLen -= 32;
	
	/* Pare sub-element field. */
	/*subEidPtr = (PFT_OPTION_FIELD)(pFtIe->Option); */
	ptr = pFtIe->Option;
	while (RemainLen > 0)
	{
		subEidPtr = (PFT_OPTION_FIELD)ptr;
	
		switch(subEidPtr->SubElementId)
		{
			case FT_R0KH_ID:
				if ((subEidPtr->Len > 0) && (subEidPtr->Len <=FT_ROKH_ID_LEN))
				{
					pFtIeInfo->R0khIdLen = subEidPtr->Len;
					NdisMoveMemory(pFtIeInfo->R0khId, subEidPtr->Oct,
						pFtIeInfo->R0khIdLen);
				}
				else
					DBGPRINT(RT_DEBUG_ERROR, ("%s Invalid R0KHID Length (%d)\n",
						__FUNCTION__, subEidPtr->Len));
				break;

			case FT_R1KH_ID:
				if (subEidPtr->Len == FT_R1KH_ID_LEN)
				{
					pFtIeInfo->R1khIdLen = subEidPtr->Len;
					NdisMoveMemory(pFtIeInfo->R1khId, subEidPtr->Oct,
						pFtIeInfo->R1khIdLen);
				}
				else
					DBGPRINT(RT_DEBUG_ERROR, ("%s Invalid R1KHID Length (%d)\n",
						__FUNCTION__, subEidPtr->Len));
				break;

			case FT_GTK:
				if (subEidPtr->Len > 0)
				{
					pFtIeInfo->GtkLen = subEidPtr->Len;
					NdisMoveMemory(pFtIeInfo->GtkSubIE, &subEidPtr->Oct[0], subEidPtr->Len);
				}
				break;

			default:
				break;
		}

		ptr += (subEidPtr->Len + 2);
		RemainLen -= (subEidPtr->Len + 2);

		/* avoid infinite loop. */
		if (subEidPtr->Len == 0)
			break;
	}
}

#ifdef CONFIG_STA_SUPPORT
VOID FT_FTIeParse(
	IN		UINT8		FtIeLen,
	IN		PFT_FTIE	pFtIe,
	OUT		PUCHAR		pR1KH_Id,
	OUT		UCHAR		*GTKLen,
	OUT		PUCHAR		pGTK,
	OUT		UCHAR		*R0KH_IdLen,
	OUT		PUCHAR		pR0KH_Id)
{
	UCHAR	*ptr;
	UINT8	RemainLen;
	PFT_OPTION_FIELD subEidPtr;

	*GTKLen = 0;
	*R0KH_IdLen = 0;

	ptr = (PUCHAR)&pFtIe->Option[0];
	RemainLen = FtIeLen - sizeof(FT_FTIE);
	DBGPRINT(RT_DEBUG_TRACE, ("FT_TEMP- FtIeParse (  FtIeLen = %d )\n", FtIeLen));
	DBGPRINT(RT_DEBUG_TRACE, ("FT_TEMP- FtIeParse ( Len that doesn't include subelement = %d )\n", RemainLen));

	while (RemainLen > 0)
	{
		subEidPtr = (PFT_OPTION_FIELD)ptr;
	
		if (subEidPtr->SubElementId == FT_R1KH_ID)
		{
			RTMPMoveMemory(pR1KH_Id, subEidPtr->Oct, subEidPtr->Len);	
			DBGPRINT(RT_DEBUG_TRACE, ("%s : R1KHID length(%d)\n", __FUNCTION__, subEidPtr->Len));
		}
		else if (subEidPtr->SubElementId == FT_GTK)
		{
			*GTKLen = subEidPtr->Len;
			DBGPRINT(RT_DEBUG_TRACE, ("FT_TEMP- FtIeParse ( *GTKLen = %d )\n", *GTKLen));
			if ((*GTKLen >= 15) && (*GTKLen <= 64))
			{
				RTMPMoveMemory(pGTK, subEidPtr->Oct, subEidPtr->Len);
			}
			else
			{
				*GTKLen = 0;
				DBGPRINT(RT_DEBUG_ERROR, ("FT- FtIeParse ( Invalid  GTKLen  = %d)\n", *GTKLen));
			}
			
		}
		else if (subEidPtr->SubElementId == FT_R0KH_ID)
		{
			*R0KH_IdLen = subEidPtr->Len;
			DBGPRINT(RT_DEBUG_TRACE, ("FT_TEMP- FtIeParse ( *R0KH_IdLen = %d )\n", *R0KH_IdLen));
			if ((*R0KH_IdLen >= 1) && (*R0KH_IdLen <= 48))
			{
				RTMPMoveMemory(pR0KH_Id, subEidPtr->Oct, subEidPtr->Len);
			}
			else
			{
				DBGPRINT(RT_DEBUG_ERROR, ("FT- FtIeParse ( Invalid  R0KH_IdLen = %d )\n",*R0KH_IdLen));
				*R0KH_IdLen = 0;
			}
			
		}
		
		ptr += (subEidPtr->Len + 2);
		RemainLen -= (subEidPtr->Len + 2);
	}

	DBGPRINT(RT_DEBUG_TRACE, ("%s done\n", __FUNCTION__));

}


/*
	==========================================================================
	Description:
		

	IRQL = DISPATCH_LEVEL

	Output:
	==========================================================================
 */
BOOLEAN FT_CheckForRoaming(
	IN	PRTMP_ADAPTER	pAd)
{
	USHORT		i;
	BSS_TABLE	*pRoamTab = &pAd->MlmeAux.RoamTab;
	BSS_ENTRY	*pBss;

	DBGPRINT(RT_DEBUG_TRACE, ("==> FT_CheckForRoaming\n"));
	/* put all roaming candidates into RoamTab, and sort in RSSI order */
	BssTableInit(pRoamTab);
	for (i = 0; i < pAd->ScanTab.BssNr; i++)
	{
		pBss = &pAd->ScanTab.BssEntry[i];

		if (pBss->bHasMDIE == FALSE)
			continue;	/* skip legacy AP */

		if (MAC_ADDR_EQUAL(pBss->Bssid, pAd->CommonCfg.Bssid))
		{
			continue;	 /* skip current AP */
		}
		if (!FT_MDID_EQU(pBss->FT_MDIE.MdId, pAd->StaCfg.Dot11RCommInfo.MdIeInfo.MdId))
		{
			continue;	 /* skip different MDID */
		}
        if ((pBss->Rssi <= -85) && (pBss->Channel == pAd->CommonCfg.Channel))
        {
			continue;	/* skip RSSI too weak at the same channel */
        }
		if ((pBss->Channel != pAd->CommonCfg.Channel) &&
			(pBss->FT_MDIE.FtCapPlc.field.FtOverDs == FALSE))
		{
			continue;	/* skip AP in different channel without supporting FtOverDs */
		}

        if (pBss->Rssi < (RTMPMaxRssi(pAd, pAd->StaCfg.RssiSample.LastRssi0, pAd->StaCfg.RssiSample.LastRssi1, pAd->StaCfg.RssiSample.LastRssi2) + RSSI_DELTA)) 
        {
			continue;	/* skip AP without better RSSI */
        }

		if ((pBss->AuthMode != pAd->StaCfg.AuthMode) ||
			(pBss->WepStatus != pAd->StaCfg.WepStatus))
		{
			continue;	 /* skip different Security Setting */
		}
		
        DBGPRINT(RT_DEBUG_TRACE, ("LastRssi0 = %d, pBss->Rssi = %d\n", RTMPMaxRssi(pAd, pAd->StaCfg.RssiSample.LastRssi0, pAd->StaCfg.RssiSample.LastRssi1, pAd->StaCfg.RssiSample.LastRssi2), pBss->Rssi));
		/* AP passing all above rules is put into roaming candidate table */
		NdisMoveMemory(&pRoamTab->BssEntry[pRoamTab->BssNr], pBss, sizeof(BSS_ENTRY));
		pRoamTab->BssNr += 1;
	}

	DBGPRINT(RT_DEBUG_TRACE, ("<== FT_CheckForRoaming (BssNr=%d)\n", pRoamTab->BssNr));
	if (pRoamTab->BssNr > 0)
	{
		/* check CntlMachine.CurrState to avoid collision with NDIS SetOID request */
		if (pAd->Mlme.CntlMachine.CurrState == CNTL_IDLE)
		{
			pAd->RalinkCounters.PoorCQIRoamingCount ++;
			DBGPRINT(RT_DEBUG_TRACE, ("MMCHK - Roaming attempt #%ld\n", pAd->RalinkCounters.PoorCQIRoamingCount));
			MlmeEnqueue(pAd, MLME_CNTL_STATE_MACHINE, MT2_MLME_ROAMING_REQ, 0, NULL, 0);
			RTMP_MLME_HANDLER(pAd);
			return TRUE;
		}
	}

	return FALSE;
}

BOOLEAN	FT_GetMDIE(
	IN  PNDIS_802_11_VARIABLE_IEs	pVIE,
	IN  USHORT						LengthVIE,
	OUT FT_MDIE_INFO				*pMdIeInfo)
{
	PEID_STRUCT     pEid;
	USHORT          Length = 0;

	pEid = (PEID_STRUCT) pVIE;
	pMdIeInfo->Len = 0;
	while ((Length + 2 + (USHORT)pEid->Len) <= LengthVIE)    
	{
		switch(pEid->Eid)
		{
			case IE_FT_MDIE:
				if (pEid->Len == sizeof(FT_MDIE))
				{
					NdisMoveMemory(&pMdIeInfo->MdId[0], &pEid->Octet[0], FT_MDID_LEN);
					pMdIeInfo->FtCapPlc.word = pEid->Octet[FT_MDID_LEN];
					pMdIeInfo->Len = pEid->Len;
				}
				return TRUE;
		}
		Length = Length + 2 + pEid->Len;  /* Eid[1] + Len[1]+ content[Len] */
        pEid = (PEID_STRUCT)((UCHAR*)pEid + 2 + pEid->Len);   
	}
	return FALSE;
}


BOOLEAN FT_ExtractGTKSubIe(
	IN	PRTMP_ADAPTER 		pAd,
	IN 	PMAC_TABLE_ENTRY 	pEntry,
	IN	PFT_FTIE_INFO		pFtInfo)
{
	PFT_GTK_KEY_INFO 	pKeyInfo;	
	UCHAR				gtk_len;
	UINT				unwrap_len;
	PUINT8				pData;
	UINT8				data_offset = 0;
	UINT8				key_p[64];

	if (pFtInfo->GtkLen < 11)
	{
		DBGPRINT_ERR(("%s : The length is invalid\n", __FUNCTION__));
		return FALSE;
	}

	pData = pFtInfo->GtkSubIE;

	/* Extract the Key Info field */
	pKeyInfo = (PFT_GTK_KEY_INFO)pData;
	pKeyInfo->word = cpu2le16(pKeyInfo->word);
	pAd->StaCfg.DefaultKeyId = pKeyInfo->field.KeyId;
	data_offset += sizeof(FT_GTK_KEY_INFO);

	DBGPRINT(RT_DEBUG_TRACE, ("%s : key idx(%d) \n", __FUNCTION__, pAd->StaCfg.DefaultKeyId));

	/* Extract the Key Length field */
	gtk_len = *(pData + data_offset);
	data_offset += 1;

	/* Extract the RSC field */
	data_offset += 8;

	/* Decrypt the Key field by AES Key UNWRAP */
	AES_Key_Unwrap(pData + data_offset, pFtInfo->GtkLen - data_offset, 
				   &pEntry->PTK[LEN_PTK_KCK], LEN_PTK_KEK, 
				   key_p, &unwrap_len);

	/* Compare the GTK length */
	if (unwrap_len != gtk_len)
	{
		DBGPRINT_ERR(("%s : The GTK length is unmatched\n", __FUNCTION__));
		return FALSE;
	}	
	
	/* set key material, TxMic and RxMic */
	NdisZeroMemory(pAd->StaCfg.GTK, MAX_LEN_GTK);
	NdisMoveMemory(pAd->StaCfg.GTK, key_p, gtk_len);
	
	return TRUE;
}

/*	
========================================================================
Routine Description:

Arguments:

Return Value:

Note:

========================================================================
*/
VOID FT_ConstructAuthReqInRsn(
	IN 	PRTMP_ADAPTER 	pAd,
	IN 	PUCHAR 			pFrameBuf,
	OUT PULONG 			pFrameLen)
{
	UINT8 	FtIeLen = 0;
	FT_MIC_CTR_FIELD FtMicCtr;
	UINT8	ft_mic[16];
	UINT8	anonce[32];

	/* Insert RSNIE[PMKR0Name] */
	RTMPInsertRSNIE(pFrameBuf + (*pFrameLen), 
					pFrameLen, 
					pAd->StaCfg.RSN_IE, 
					pAd->StaCfg.RSNIE_Len, 
					pAd->StaCfg.Dot11RCommInfo.PMKR0Name, 
					LEN_PMK_NAME);

	/* 	Insert FTIE[SNonce, R0KH-ID] 
		R0KH-ID: Optional parameter - Sub-EID(1 byte)+Len(1 byte)+Data(variable bytes) */
	FtIeLen = sizeof(FT_FTIE) + 2 + pAd->StaCfg.Dot11RCommInfo.R0khIdLen;
	FtMicCtr.word = 0;
	GenRandom(pAd, pAd->CurrentAddress, pAd->MlmeAux.FtIeInfo.SNonce);
	NdisZeroMemory(ft_mic, 16);
	NdisZeroMemory(anonce, 32);
	
	FT_InsertFTIE(pAd, 
				  pFrameBuf + (*pFrameLen), 
				  pFrameLen, 
				  FtIeLen, 
				  FtMicCtr, 
				  ft_mic, 
				  anonce, 
				  &pAd->MlmeAux.FtIeInfo.SNonce[0]);
	
	FT_FTIE_InsertKhIdSubIE(pAd, 
							pFrameBuf + (*pFrameLen), 
							pFrameLen, 
							FT_R0KH_ID, 
							&pAd->StaCfg.Dot11RCommInfo.R0khId[0], 
							pAd->StaCfg.Dot11RCommInfo.R0khIdLen);
	

}

#endif /* CONFIG_STA_SUPPORT */

/*
	========================================================================
	
	Routine Description:
		It is used to derive the first level FT Key Hierarchy key, PMK-R0, 
		and its identifier PMKR0Name.
		(IEEE 802.11r/D9.0, 8.5.1.5.3)

	Arguments:

	Return Value:

	Note:
		R0-Key-Data = 
			KDF-384(XXKey, "FT-R0", 
					SSIDlength || SSID || MDID || 
					R0KHlength || R0KH-ID || S0KH-ID)
		PMK-R0 = L(R0-Key-Data, 0, 256)
		PMK-R0Name-Salt = L(R0-Key-Data, 256, 128)		

		PMKR0Name = Truncate-128(SHA-256("FT-R0N" || PMK-R0Name-Salt))

	========================================================================
*/
VOID FT_DerivePMKR0(
	IN	PUINT8	xxkey,
	IN	INT		xxkey_len,
	IN	PUINT8	ssid,
	IN	INT		ssid_len,
	IN	PUINT8	mdid,
	IN	PUINT8 r0khid,
	IN	INT		r0khid_len,
	IN	PUINT8	s0khid,
	OUT	PUINT8	pmkr0,
	OUT	PUINT8	pmkr0_name)
{	
	const char label_name[] = "FT-R0N";
	UCHAR	R0KeyData[96];
	UCHAR	PmkR0NameSalt[20];
	UCHAR	temp_result[64];
	UCHAR   context[128];
	UINT    c_len=0; 

	/* =========================== */
	/* 		PMK-R0 derivation */
	/* =========================== */

	/* construct the concatenated context for PMK-R0 */
	/* SSIDlength(1 byte) */
	/* SSID(0~32 bytes) */
	/* MDID(2 bytes) */
	/* R0KHlength(1 byte) */
	/* R0KH-ID(5~48 bytes) */
	/* S0KH-ID(6 bytes) */

	hex_dump("xxkey", (PUCHAR)xxkey, xxkey_len);
	hex_dump("label", (PUCHAR)label_name, sizeof(label_name));
	hex_dump("ssid", (PUCHAR)ssid, ssid_len);
	hex_dump("mdis", (PUCHAR)mdid, 2);
	hex_dump("r0khid", (PUCHAR)r0khid, r0khid_len);
	hex_dump("s0khid", (PUCHAR)s0khid, MAC_ADDR_LEN);

	/* Initial the related context */
	NdisZeroMemory(temp_result, 64);
	NdisZeroMemory(context, 128);
	c_len = 0;

	/* concatenate the SSIDlength with a single octet */
	context[0] = ssid_len;
	c_len += 1;

	/* concatenate the SSID with its length */
	NdisMoveMemory(&context[c_len], ssid, ssid_len);
	c_len += ssid_len;

	/* concatenate the MDID with 2-octets */
	NdisMoveMemory(&context[c_len], mdid, 2);
	c_len += 2;

	/* concatenate the R0KHlength with a single octet */
	context[c_len] = r0khid_len;
	c_len += 1;

	/* concatenate the R0KH-ID with its length */
	NdisMoveMemory(&context[c_len], r0khid, r0khid_len);
	c_len += r0khid_len;

	/* concatenate the S0KH-ID with its length */
	NdisMoveMemory(&context[c_len], s0khid, MAC_ADDR_LEN);
	c_len += MAC_ADDR_LEN;

	/* Calculate a 48-bytes key material through FT-KDF */
	KDF(xxkey, xxkey_len, (PUINT8)"FT-R0", 5, context, c_len, R0KeyData, 48);

	/* PMK-R0 key shall be computed as the first 256 bits (bits 0-255) */
	/* of the R0-Key-Data. The latter 128 bits of R0-Key-Data shall */
	/* be used as the PMK-R0Name-Salt to generate the PMKR0Name. */
	NdisMoveMemory(pmkr0, R0KeyData, LEN_PMK);
	NdisMoveMemory(PmkR0NameSalt, &R0KeyData[32], LEN_PMK_NAME);

	/* =============================== */
	/* 		PMK-R0-Name derivation */
	/* =============================== */
	
	/* Initial the related parameter for PMK-R0-Name derivation */
	NdisZeroMemory(temp_result, 64);
	NdisZeroMemory(context, 128);
	c_len = 0;

	/* concatenate the label with its length */
	NdisMoveMemory(context, label_name, strlen(label_name));
	c_len += strlen(label_name);

	/* concatenate the PMK-R0Name-Salt with its length */
	NdisMoveMemory(&context[c_len], PmkR0NameSalt, LEN_PMK_NAME);
	c_len += LEN_PMK_NAME;

	RT_SHA256(context, c_len, temp_result);
	NdisMoveMemory(pmkr0_name, temp_result, LEN_PMK_NAME);

	hex_dump("PMK-R0", (UCHAR *)pmkr0, LEN_PMK);
	hex_dump("PMK-R0-Name", (UCHAR *)pmkr0_name, LEN_PMK_NAME);
	
}

/*
	========================================================================
	
	Routine Description:
		It is used to derive the second level FT Key Hierarchy key 
		identifier, PMK-R1-NAME.
		(IEEE 802.11r/D9.0, 8.5.1.5.4)

	Arguments:

	Return Value:

	Note:		
		PMKR1Name = Truncate-128(SHA-256("FT-R1N" || PMKR0Name || R1KH-ID || S1KH-ID))

	========================================================================
*/
VOID FT_DerivePMKR1Name(
	IN	PUINT8	pmkr0_name,
	IN	PUINT8 	r1khid,
	IN	PUINT8	s1khid,
	OUT	PUINT8	pmkr1_name)
{	
	const char label_name[] = "FT-R1N";
	UCHAR	temp_result[64];
	UCHAR   context[128];
	UINT    c_len = 0; 

	/* =============================== */
	/* 		PMK-R1-Name derivation */
	/* =============================== */

	/* Initial the related parameter for PMK-R1-Name derivation */
	NdisZeroMemory(temp_result, 64);
	NdisZeroMemory(context, 128);
	c_len = 0;

	/* concatenate the label with its length */
	NdisMoveMemory(context, label_name, strlen(label_name));
	c_len += strlen(label_name);

	/* concatenate the PMK-R1-Name with 16-octets */
	NdisMoveMemory(&context[c_len], pmkr0_name, LEN_PMK_NAME);
	c_len += LEN_PMK_NAME;

	/* concatenate the R1KH-ID with 6-octets */
	NdisMoveMemory(&context[c_len], r1khid, MAC_ADDR_LEN);
	c_len += MAC_ADDR_LEN;

	/* concatenate the S1KH-ID with 6-octets */
	NdisMoveMemory(&context[c_len], s1khid, MAC_ADDR_LEN);
	c_len += MAC_ADDR_LEN;

	/* derive PMK-R1-Name */
	RT_SHA256(context, c_len, temp_result);
	NdisMoveMemory(pmkr1_name, temp_result, LEN_PMK_NAME);
	
	hex_dump("PMK-R1-Name", (UCHAR *)pmkr1_name, LEN_PMK_NAME);
	
}

/*
	========================================================================
	
	Routine Description:
		It is used to derive the second level FT Key Hierarchy key, PMK-R1,
		and its identifier PMKR1Name.
		(IEEE 802.11r/D9.0, 8.5.1.5.4)

	Arguments:

	Return Value:

	Note:
		PMK-R1 = KDF-256(PMK-R0, "FT-R1", R1KH-ID || S1KH-ID)
		PMKR1Name = Truncate-128(SHA-256("FT-R1N" || PMKR0Name || R1KH-ID || S1KH-ID))

	========================================================================
*/
VOID FT_DerivePMKR1(
	IN	PUINT8	pmkr0,
	IN	PUINT8	pmkr0_name,
	IN	PUINT8 r1khid,
	IN	PUINT8	s1khid,
	OUT	PUINT8	pmkr1,
	OUT	PUINT8	pmkr1_name)
{	
	/*const char label_name[] = "FT-R1N"; */
	UCHAR	temp_result[64];
	UCHAR   context[128];
	UINT    c_len=0; 

	/* =========================== */
	/* 		PMK-R1 derivation */
	/* =========================== */

	DBGPRINT(RT_DEBUG_TRACE, ("%s:\n", __FUNCTION__));
	hex_dump("pmkr0", pmkr0, 32);
	hex_dump("pmkr0_name", pmkr0_name, LEN_PMK_NAME);
	hex_dump("r1khid", r1khid, MAC_ADDR_LEN);
	hex_dump("s1khid", s1khid, MAC_ADDR_LEN);
	hex_dump("pmkr1", pmkr1, 32);
	hex_dump("pmkr1_name", pmkr1_name, 16);

	/* construct the concatenated context for PMK-R1 */
	/* R1KH-ID(6 bytes) */
	/* S1KH-ID(6 bytes) */

	/* Initial the related parameter */
	NdisZeroMemory(temp_result, 64);
	NdisZeroMemory(context, 128);
	c_len = 0;
	
	/* concatenate the R1KH-ID with 6-octets */
	NdisMoveMemory(&context[c_len], r1khid, MAC_ADDR_LEN);
	c_len += MAC_ADDR_LEN;

	/* concatenate the S1KH-ID with 6-octets */
	NdisMoveMemory(&context[c_len], s1khid, MAC_ADDR_LEN);
	c_len += MAC_ADDR_LEN;

	/* Calculate a 32-bytes key material through FT-KDF */
	KDF(pmkr0, LEN_PMK, (PUINT8)"FT-R1", 5, context, c_len, temp_result, 32);
	NdisMoveMemory(pmkr1, temp_result, LEN_PMK);

	/* =============================== */
	/* 		PMK-R1-Name derivation */
	/* =============================== */
	FT_DerivePMKR1Name(pmkr0_name, 
					   r1khid, 
					   s1khid, 
					   pmkr1_name);

	hex_dump("PMK-R1", (UCHAR *)pmkr1, LEN_PMK);
	hex_dump("PMK-R1-Name", (UCHAR *)pmkr1_name, LEN_PMK_NAME);
	
}

/*
	========================================================================
	
	Routine Description:
		It is used to derive the third level FT Key Hierarchy key, PTK,
		and its identifier PTKName.
		(IEEE 802.11r/D9.0, 8.5.1.5.4)

	Arguments:

	Return Value:

	Note:
		PTK = KDF-PTKLen(PMK-R1, "FT-PTK", SNonce || ANonce || BSSID || STA-ADDR)
		PTKName = 
			Truncate-128(SHA-256(PMKR1Name || "FT-PTKN" || SNonce || ANonce || BSSID || 
							STA-ADDR))

	========================================================================
*/
VOID FT_DerivePTK(
	IN	PUINT8	pmkr1,
	IN	PUINT8	pmkr1_name,
	IN	PUINT8 	a_nonce,
	IN	PUINT8 	s_nonce,
	IN	PUINT8 	bssid,
	IN	PUINT8 	sta_mac,
	IN	UINT	key_len,
	OUT	PUINT8	ptk,
	OUT	PUINT8	ptk_name)
{	
	const char label_name[] = "FT-PTKN";
	UCHAR	temp_result[64];
	UCHAR   context[128];
	UINT    c_len=0; 

	/* =============================== */
	/* 		PTK derivation */
	/* =============================== */

	/* construct the concatenated context for PTK */
	/* SNonce (32 bytes) */
	/* ANonce (32 bytes) */
	/* BSSID (6 bytes) */
	/* STA-ADDR (6-bytes) */

	/* Initial the related parameter */
	NdisZeroMemory(temp_result, 64);
	NdisZeroMemory(context, 128);
	c_len = 0;
	
	/* concatenate the SNonce with 32-octets */
	NdisMoveMemory(&context[c_len], s_nonce, LEN_NONCE);
	c_len += LEN_NONCE;

	/* concatenate the ANonce with 32-octets */
	NdisMoveMemory(&context[c_len], a_nonce, LEN_NONCE);
	c_len += LEN_NONCE;

	/* concatenate the BSSID with 6-octets */
	NdisMoveMemory(&context[c_len], bssid, MAC_ADDR_LEN);
	c_len += MAC_ADDR_LEN;

	/* concatenate the STA-ADDR with 6-octets */
	NdisMoveMemory(&context[c_len], sta_mac, MAC_ADDR_LEN);
	c_len += MAC_ADDR_LEN;

	/* Calculate a key material through FT-KDF */
	KDF(pmkr1, 
			LEN_PMK, 
			(PUINT8)"FT-PTK", 
			6, 
			context, 
			c_len, 
			temp_result, 
			key_len);
	NdisMoveMemory(ptk, temp_result, key_len);

	/* =============================== */
	/* 		PTK-Name derivation */
	/* =============================== */

	/* Initial the related parameter for PTK-Name derivation */
	NdisZeroMemory(temp_result, 64);
	NdisZeroMemory(context, 128);
	c_len = 0;

	/* concatenate the PMK-R1-Name with 16-octets */
	NdisMoveMemory(&context[c_len], pmkr1_name, LEN_PMK_NAME);
	c_len += LEN_PMK_NAME;

	/* concatenate the label with its length */
	NdisMoveMemory(&context[c_len], label_name, strlen(label_name));
	c_len += strlen(label_name);

	/* concatenate the SNonce with 32-octets */
	NdisMoveMemory(&context[c_len], s_nonce, LEN_NONCE);
	c_len += LEN_NONCE;

	/* concatenate the ANonce with 32-octets */
	NdisMoveMemory(&context[c_len], a_nonce, LEN_NONCE);
	c_len += LEN_NONCE;

	/* concatenate the BSSID with 6-octets */
	NdisMoveMemory(&context[c_len], bssid, MAC_ADDR_LEN);
	c_len += MAC_ADDR_LEN;

	/* concatenate the STA-ADDR with 6-octets */
	NdisMoveMemory(&context[c_len], sta_mac, MAC_ADDR_LEN);
	c_len += MAC_ADDR_LEN;

	/* Derive PTKName */
	RT_SHA256(context, c_len, temp_result);
	NdisMoveMemory(ptk_name, temp_result, LEN_PMK_NAME);

	/*hex_dump("ANonce", (UCHAR *)a_nonce, LEN_NONCE); */
	/*hex_dump("SNonce", (UCHAR *)s_nonce, LEN_NONCE); */

	hex_dump("PTK", (UCHAR *)ptk, key_len);
	hex_dump("PTK-Name", (UCHAR *)ptk_name, LEN_PMK_NAME);
	
}


/*
	========================================================================
	
	Routine Description:
		Calcaulate FT MIC. It is used during Fast BSS transition.

	Arguments:

	Return Value:

	Note:
		It's defined in IEEE 802.11r D9.0 11A.8.4/8.5
		The MIC shall be calculated using the KCK and the AES-128-CMAC 
		algorithm. The output of the AES-128-CMAC shall be 128 bits.

		The MIC shall be calculated on the concatenation, in the 
		following order, of:
		-  non-AP STA MAC address (6 octets)
		-  Target AP MAC address (6 octets)
		-  Transaction sequence number (1 octet)
		-  Contents of the RSN information element.
		-  Contents of the MDIE.
		-  Contents of the FTIE, with the MIC field of the FTIE set to 0.
		-  Contents of the RIC-Request (if present)
		
	========================================================================
*/
VOID	FT_CalculateMIC(
	IN	PUINT8		sta_addr,	
	IN	PUINT8		ap_addr,
	IN	PUINT8		kck,
	IN	UINT8		seq,
	IN  PUINT8		rsnie,
	IN	UINT8		rsnie_len,
	IN	PUINT8		mdie,
	IN	UINT8		mdie_len,
	IN	PUINT8		ftie,
	IN	UINT8		ftie_len,
	IN	PUINT8		ric,
	IN	UINT8		ric_len,
	OUT PUINT8		mic)
{
    UCHAR   *OutBuffer;
	ULONG	FrameLen = 0;
	ULONG	TmpLen = 0;
	UINT	mlen = AES_KEY128_LENGTH;

	DBGPRINT(RT_DEBUG_TRACE, ("%s\n", __FUNCTION__));
	
	NdisZeroMemory(mic, sizeof(mic));
	
	/* allocate memory for MIC calculation */
	os_alloc_mem(NULL, (PUCHAR *)&OutBuffer, 512);
    if (OutBuffer == NULL)
    {
		DBGPRINT(RT_DEBUG_ERROR, ("!!!FT_CalculateMIC: no memory!!!\n"));
		return;
    }
		
	/* make a header frame for calculating MIC. */
    MakeOutgoingFrame(OutBuffer,            		&TmpLen,
                      MAC_ADDR_LEN,  				sta_addr,
                      MAC_ADDR_LEN,  				ap_addr,
                      1,							&seq,
                      END_OF_ARGS);
	FrameLen += TmpLen;					

	/* concatenate RSNIE */
	if (rsnie_len != 0)
	{				
	    MakeOutgoingFrame(OutBuffer + FrameLen,		&TmpLen,
	                      rsnie_len,	  			rsnie,
	                      END_OF_ARGS);
		FrameLen += TmpLen;					
	}
	
	/* concatenate MDIE */
	if (mdie_len != 0)
	{		
	    MakeOutgoingFrame(OutBuffer + FrameLen,		&TmpLen,
	                      mdie_len,	  				mdie,
	                      END_OF_ARGS);
		FrameLen += TmpLen;					
	}
	
	/* concatenate FTIE */
	if (ftie != 0)
	{
		/* The MIC field of the FTIE set to 0 */		
		NdisZeroMemory(ftie + 4, 16);
		
	    MakeOutgoingFrame(OutBuffer + FrameLen,		&TmpLen,
	                      ftie_len,	  				ftie,
	                      END_OF_ARGS);
		FrameLen += TmpLen;					
	}	
	
	/* concatenate RIC-Request/Response if present */
	if (ric != 0)
	{
		MakeOutgoingFrame(OutBuffer + FrameLen,     &TmpLen,
						  ric_len,					ric,
						  END_OF_ARGS);
		FrameLen += TmpLen;
	}
	
	/* Calculate MIC */				
	AES_CMAC(OutBuffer, FrameLen, kck, LEN_PTK_KCK, mic, &mlen);

	os_free_mem(NULL, OutBuffer);
}


#endif /* DOT11R_FT_SUPPORT */

