/****************************************************************************
 * Ralink Tech Inc.
 * Taiwan, R.O.C.
 *
 * (c) Copyright 2002, Ralink Technology, Inc.
 *
 * All rights reserved. Ralink's source code is an unpublished work and the
 * use of a copyright notice does not imply otherwise. This source code
 * contains confidential trade secret material of Ralink Tech. Any attemp
 * or participation in deciphering, decoding, reverse engineering or in any
 * way altering the source code is stricitly prohibited, unless the prior
 * written consent of Ralink Technology, Inc. is obtained.
 ***************************************************************************/

/****************************************************************************

	Abstract:

	All related IEEE802.11r IOCTL function body.

***************************************************************************/

#ifdef DOT11R_FT_SUPPORT



#include "rt_config.h"

#define TYPE_FUNC
#define FT_FUNC_SIMULATION

#ifdef FT_FUNC_SIMULATION
#endif /* FT_FUNC_SIMULATION */

/* ----- Private Variable ----- */
#ifdef FT_FUNC_SIMULATION
static UCHAR gFT_MAC_STA[ETH_ALEN] = { 0x00, 0x0e, 0x2e, 0x82, 0xe7, 0x6d };
UCHAR gFT_MAC_OldAP[ETH_ALEN] = { 0x00, 0x0e, 0x2e, 0x12, 0x34, 0x56 };

#ifdef CONFIG_STA_SUPPORT
#define FT_RIC_SIM_AP_MAX	10
static FT_RIC_STATUS gFT_RIC_RspStatus[FT_RIC_SIM_AP_MAX];
static UINT32 gFT_RIC_RspStatusIndex;
#endif /* CONFIG_STA_SUPPORT */

#endif /* FT_FUNC_SIMULATION */


/* ----- Extern Function ----- */


/* ----- Private Function ----- */
#define FT_CMD_INPUT_PARAM_DECLARATION	\
	PRTMP_ADAPTER pAd, INT32 Argc, CHAR *pArgv


#ifdef CONFIG_STA_SUPPORT
#ifdef FT_FUNC_SIMULATION
static VOID FT_RIC_CMD_StatusDisplay(FT_RIC_STATUS *pRspStatus);
static VOID FT_RIC_CMD_SimRscReqStart(FT_CMD_INPUT_PARAM_DECLARATION);
static VOID FT_RIC_CMD_SimRscReq(FT_CMD_INPUT_PARAM_DECLARATION);
static VOID FT_RIC_CMD_SimRscReqEnd(FT_CMD_INPUT_PARAM_DECLARATION);
static VOID FT_RIC_CMD_SimRscReqRspList(FT_CMD_INPUT_PARAM_DECLARATION);
#endif /* FT_FUNC_SIMULATION */
#endif /* CONFIG_STA_SUPPORT */

static UINT32 FT_CMD_UtilHexGet(CHAR **ppArgv);
static UINT32 FT_CMD_UtilNumGet(CHAR **ppArgv);
static VOID FT_CMD_UtilMacGet(CHAR **ppArgv, UCHAR *pDevMac);




/*
========================================================================
Routine Description:
	Get argument number value.

Arguments:
	**ppArgv			- input parameters

Return Value:
	decimal number

Note:
========================================================================
*/
static UINT32 TYPE_FUNC FT_CMD_UtilHexGet(
	IN	CHAR	**ppArgv)
{
	CHAR buf[3], *pNum;
	UINT32 ID;
	UCHAR Value;


	pNum = (*ppArgv);

	buf[0] = 0x30;
	buf[1] = 0x30;
	buf[2] = 0;

	for(ID=0; ID<sizeof(buf)-1; ID++)
	{
		if ((*pNum == '_') || (*pNum == 0x00))
			break;
		/* End of if */

		pNum ++;
	} /* End of for */

	if (ID == 0)
		return 0; /* argument length is too small */
	/* End of if */

	if (ID >= 2)
		memcpy(buf, (*ppArgv), 2);
	else
		buf[1] = (**ppArgv);
	/* End of if */

	(*ppArgv) += ID;
	if ((**ppArgv) == '_')
		(*ppArgv) ++; /* skip _ */
	/* End of if */

	FT_ARG_ATOH(buf, &Value);
	return (UINT32)Value;
} /* End of FT_CMD_UtilHexGet */


/*
========================================================================
Routine Description:
	Get argument number value.

Arguments:
	*pArgv			- input parameters

Return Value:
	decimal number

Note:
========================================================================
*/
static UINT32 TYPE_FUNC FT_CMD_UtilNumGet(
	IN	CHAR	**ppArgv)
{
	CHAR buf[20], *pNum;
	UINT32 ID;


	pNum = (*ppArgv);

	for(ID=0; ID<sizeof(buf)-1; ID++)
	{
		if ((*pNum == '_') || (*pNum == 0x00))
			break;
		/* End of if */

		pNum ++;
	} /* End of for */

	if (ID == sizeof(buf)-1)
		return 0; /* argument length is too large */
	/* End of if */

	memcpy(buf, (*ppArgv), ID);
	buf[ID] = 0x00;

	*ppArgv += ID+1; /* skip _ */

	return FT_ARG_ATOI(buf);
} /* End of FT_CMD_UtilNumGet */


/*
========================================================================
Routine Description:
	Get argument MAC value.

Arguments:
	**ppArgv			- input parameters
	*pDevMac			- MAC address

Return Value:
	None

Note:
========================================================================
*/
static VOID TYPE_FUNC FT_CMD_UtilMacGet(
	IN	CHAR	**ppArgv,
	IN	UCHAR	*pDevMac)
{
	CHAR Buf[3];
	CHAR *pMAC = (CHAR *)(*ppArgv);
	UINT32 ID;


	if ((pMAC[0] == '0') && (pMAC[1] == '_'))
	{
		*ppArgv = (&pMAC[2]);
		return;
	} /* End of if */

	memset(pDevMac, 0, ETH_ALEN);

	/* must exist 18 octets */
	for(ID=0; ID<18; ID+=2)
	{
		if ((pMAC[ID] == '_') || (pMAC[ID] == 0x00))
		{
			*ppArgv = (&pMAC[ID]+1);
			return;
		} /* End of if */
	} /* End of for */

	/* get mac */
	for(ID=0; ID<18; ID+=3)
	{
		Buf[0] = pMAC[0];
		Buf[1] = pMAC[1];
		Buf[2] = 0x00;

		FT_ARG_ATOH(Buf, pDevMac);
		pMAC += 3;
		pDevMac ++;
	} /* End of for */

	*ppArgv += 17+1; /* skip _ */
} /* End of FT_CMD_UtilMacGet */




#ifdef CONFIG_STA_SUPPORT
#ifdef FT_FUNC_SIMULATION
/*
========================================================================
Routine Description:
	Display the reponse status for a resource request.

Arguments:
	*pRspStatus		- the status

Return Value:
	None

Note:
========================================================================
*/
static VOID TYPE_FUNC FT_RIC_CMD_StatusDisplay(FT_RIC_STATUS *pRspStatus)
{
	DBGPRINT_RAW(RT_DEBUG_OFF,
				("\nAP MAC = %02x:%02x:%02x:%02x:%02x:%02x\n",
				pRspStatus->AP_MAC[0], pRspStatus->AP_MAC[1],
				pRspStatus->AP_MAC[2], pRspStatus->AP_MAC[3],
				pRspStatus->AP_MAC[4], pRspStatus->AP_MAC[5]));

	if (pRspStatus->FlgHasBaResource == TRUE)
	{
		if (pRspStatus->FlgIsBaAccepted == TRUE)
		{
			DBGPRINT_RAW(RT_DEBUG_OFF, ("\tBA Resource is accepted.\n"));
		}
	else
		{
			DBGPRINT_RAW(RT_DEBUG_OFF, ("\tBA Resource is not accepted.\n"));
		} /* End of if */
	} /* End of if */

	if (pRspStatus->TspecNumberOfRequested > 0)
	{
		DBGPRINT_RAW(RT_DEBUG_OFF, ("\tNumber of requested TSPEC: %d\n",
					pRspStatus->TspecNumberOfRequested));
		DBGPRINT_RAW(RT_DEBUG_OFF, ("\tNumber of accepted TSPEC: %d\n",
					pRspStatus->TspecNumberOfAccepted));

		DBGPRINT_RAW(RT_DEBUG_OFF, ("\tTotal requested Time: %d us\n",
					pRspStatus->TspecMediumTimeTotalCur));
		DBGPRINT_RAW(RT_DEBUG_OFF, ("\tTotal accepted Time: %d us\n",
					pRspStatus->TspecMediumTimeTotalNew));
	} /* End of if */

	if (pRspStatus->UnknownRDIE > 0)
	{
		DBGPRINT_RAW(RT_DEBUG_OFF, ("\tNumber of unknown RDIE: %d\n",
					pRspStatus->UnknownRDIE));
	} /* End of if */
} /* End of FT_RIC_CMD_StatusDisplay */


/*
========================================================================
Routine Description:
	Simulate to start our resource request to the target AP.

Arguments:
	pAd				- WLAN control block pointer
	Argc			- the number of input parameters
	*pArgv			- input parameters

Return Value:
	None

Note:
	Need to build any TSPEC before.

	EX: Build a simulated TSPEC.

	iwpriv ra0 set acm=69_0_0_1_1
	iwpriv ra0 set acm=65_1_7_0_1_7_0_500_3000_200000_11000000_10_0
	iwpriv ra0 set acm=65_1_6_1_1_6_0_500_3000_200000_11000000_10_0
	iwpriv ra0 set acm=65_1_5_0_1_5_0_500_3000_200000_11000000_10_0
	iwpriv ra0 set acm=65_1_4_1_1_4_0_500_3000_200000_11000000_10_0
	iwpriv ra0 set acm=06_1_0
	iwpriv ra0 set ft=506
	iwpriv ra0 set ft=507_00:11:11:11:11:11_1_0_0_1
	iwpriv ra0 set ft=507_00:22:22:22:22:22_0_0_1_1
	iwpriv ra0 set ft=507_00:33:33:33:33:33_1_1_1_0
	iwpriv ra0 set ft=508_00:22:22:22:22:22
	iwpriv ra0 set ft=509
========================================================================
*/
static VOID TYPE_FUNC FT_RIC_CMD_SimRscReqStart(
	IN	PRTMP_ADAPTER		pAd,
	IN	INT32				Argc,
	IN	CHAR				*pArgv)
{
	FT_RIC_ResourceRequestStart(pAd);
	gFT_RIC_RspStatusIndex = 0;
} /* End of FT_RIC_CMD_SimRscReqStart */


/*
========================================================================
Routine Description:
	Simulate to send our resource request to the target AP.

Arguments:
	pAd				- WLAN control block pointer
	Argc			- the number of input parameters
	*pArgv			- input parameters

Return Value:
	None

Note:
	Command: [AP MAC] [Status for TSPEC 1] [Status for TSPEC 2]
	[Status for TSPEC 3] [Status for TSPEC 4] [Status for TSPEC 5]
	[Status for TSPEC 6] [Status for TSPEC 7] [Status for TSPEC 8]
========================================================================
*/
static VOID TYPE_FUNC FT_RIC_CMD_SimRscReq(
	IN	PRTMP_ADAPTER		pAd,
	IN	INT32				Argc,
	IN	CHAR				*pArgv)
	{
	FT_ELM_RIC_DATA_INFO *pElmDataInfoRsp;
	UCHAR *pFrame, *pFrameRDIE, *pFrameNextRDIE, *pFrameRSC;
	UINT32 FilledLen, RdieLen, RscLen, RspLen = 0;
	UCHAR MacPeer[6];
	BOOLEAN RspStatus[8];
	UINT32 IdStatus, RDIE_Index;


	/* sanity check */
	if (gFT_RIC_RspStatusIndex >= FT_RIC_SIM_AP_MAX)
		return;
	/* End of if */

	/* get AP mac address */
	FT_CMD_UtilMacGet(&pArgv, MacPeer);

	if (*(UINT32 *)MacPeer == 0)
		memcpy(MacPeer, gFT_MAC_OldAP, 6);
		/* End of if */

	memset(RspStatus, 0, sizeof(RspStatus));

	for(IdStatus=0; IdStatus<(Argc-1); IdStatus++)
		RspStatus[IdStatus] = FT_CMD_UtilNumGet(&pArgv);
	/* End of for */

	/* init */
/*	pFrame = kmalloc(1000, GFP_ATOMIC); */
	os_alloc_mem(pAd, (UCHAR **)&pFrame, 1000);
	if (pFrame == NULL)
		return;
	/* End of if */
	memset(pFrame, 0, 1000);
	RspLen = 0;

	/* simulate to request */
	FilledLen = FT_RIC_ResourceRequest(pAd, MacPeer, pFrame, 1000);

	/* modify response status */
	if (Argc > 1)
	{
		RDIE_Index = 0;
		RspLen = 0;
		pFrameRDIE = pFrame;

		while(FilledLen > 0)
		{
			/* update RDIE status */
			pElmDataInfoRsp = (FT_ELM_RIC_DATA_INFO *)pFrameRDIE;
			pElmDataInfoRsp->StatusCode = RspStatus[RDIE_Index];

			RdieLen = FT_ELM_HDR_LEN + *(pFrameRDIE+1);
			pFrameRSC = pFrameRDIE + RdieLen;
			RscLen = FT_ELM_HDR_LEN + *(pFrameRSC+1);
			RspLen += RdieLen;
			FilledLen -= (RdieLen + RscLen);

			/* update resource element */
			if (pElmDataInfoRsp->StatusCode != 0)
			{
				/* delete the following resource TSPEC */
				pElmDataInfoRsp->RD_Count = 0;

				pFrameNextRDIE = pFrameRSC + RscLen;
				memcpy(pFrameRSC, pFrameNextRDIE, FilledLen);
				pFrameRDIE += (RdieLen);
			}
			else
			{
				RspLen += RscLen;
				pFrameRDIE += (RdieLen + RscLen);
			} /* End of if */

			/* check next RDIE pair */
			RDIE_Index ++;
		} /* End of while */
	} /* End of if */

	/* simulate to response (Medium Time will be 0) */
	FT_RIC_ResourceResponseHandle(pAd, MacPeer, pFrame, RspLen,
								&gFT_RIC_RspStatus[gFT_RIC_RspStatusIndex]);

	/* display status */
	FT_RIC_CMD_StatusDisplay(&gFT_RIC_RspStatus[gFT_RIC_RspStatusIndex]);

	/* free temp use memory */
/*	kfree(pFrame); */
	os_free_mem(NULL, pFrame);

	gFT_RIC_RspStatusIndex++;
} /* End of FT_RIC_CMD_SimRscReq */


/*
========================================================================
Routine Description:
	Simulate to end our resource request to the target AP.

Arguments:
	pAd				- WLAN control block pointer
	Argc			- the number of input parameters
	*pArgv			- input parameters

Return Value:
	None

Note:
	Command: [Selected AP MAC]
========================================================================
*/
static VOID TYPE_FUNC FT_RIC_CMD_SimRscReqEnd(
	IN	PRTMP_ADAPTER		pAd,
	IN	INT32				Argc,
	IN	CHAR				*pArgv)
{
	UCHAR MacPeer[6];


	/* get selected AP mac address */
	FT_CMD_UtilMacGet(&pArgv, MacPeer);

	if (*(UINT32 *)MacPeer == 0)
		memcpy(MacPeer, gFT_MAC_OldAP, 6);
	/* End of if */

	/* end resource request mechanism */
	FT_RIC_ResourceRequestEnd(pAd, MacPeer);
} /* End of FT_RIC_CMD_SimRscReqEnd */


/*
========================================================================
Routine Description:
	Simulate to list our resource request response from all APs.

Arguments:
	pAd				- WLAN control block pointer
	Argc			- the number of input parameters
	*pArgv			- input parameters

Return Value:
	None

Note:
========================================================================
*/
static VOID TYPE_FUNC FT_RIC_CMD_SimRscReqRspList(
	IN	PRTMP_ADAPTER		pAd,
	IN	INT32				Argc,
	IN	CHAR				*pArgv)
	{
	UINT32 IdRsc;


	for(IdRsc=0; IdRsc<gFT_RIC_RspStatusIndex; IdRsc++)
	{
		FT_RIC_CMD_StatusDisplay(&gFT_RIC_RspStatus[IdRsc]);
		DBGPRINT_RAW(RT_DEBUG_OFF, ("\n"));
	} /* End of for */
} /* End of FT_RIC_CMD_SimRscReqRspList */

#endif /* FT_FUNC_SIMULATION */
#endif /* CONFIG_STA_SUPPORT */




#define FT_KDP_CMD_DAEMON_KILL			0
#define FT_KDP_CMD_EVENT_LIST			1
#define FT_KDP_CMD_DEBUG_FLAG_CTRL		2

#define FT_KDP_CMD_SM_EVT_FT_ASSOC		500
#define FT_KDP_CMD_SM_EVT_FT_REASSOC	501
#define FT_KDP_CMD_SM_EVT_KEY_REQ		502
#define FT_KDP_CMD_SM_R0KH_INFO_SHOW	503
#define FT_KDP_CMD_SM_R0KH_INFO_CREATE	504
#define FT_R1KH_INFO_SHOW				505
#define FT_RIC_CMD_SM_REQ_START			506
#define FT_RIC_CMD_SM_REQ				507
#define FT_RIC_CMD_SM_REQ_END			508
#define FT_RIC_CMD_SM_REQ_RSP_LIST		509
#define FT_RIC_CMD_SM_REQ_HANDLE		510
#define FT_RIC_CMD_SM_RRB_SEND			511
#define FT_RIC_CMD_SM_REQ_HDL_TSPEC		512
#define FT_11K_CMD_INFO_REQ				513
#define FT_KDP_KEY_SHOW					514

#define FT_REQ_ACT						600
#define FT_CONFIRM_ACT					601
#define FT_ROAMING_ACT					602

/*
========================================================================
Routine Description:
	IO control handler for IEEE802.11r.

Arguments:
	pAd				- WLAN control block pointer
	pArgvIn			- the data flow information

Return Value:
	None

Note:
	All test commands are listed as follows:
		iwpriv ra0 set ft=[cmd id]_[arg1]_[arg2]_......_[argn]
		[cmd id] = xx, such as 000, 001, 002, 003, ...
========================================================================
*/
INT TYPE_FUNC FT_Ioctl(
	IN	PRTMP_ADAPTER		pAd,
	IN	PSTRING				pArgvIn)
{
	CHAR BufCmd[4] = { 0, 0, 0, 0 };
	CHAR *pArgv, *pParam;
	UINT32 Command, CmdEndOffset, IdCmd;
	INT32 Argc;


	/* init */
	pArgv = (CHAR *)pArgvIn;

	/* get command type */
	/* command format is iwpriv ra0 set acm=[cmd id]_[arg1]_......_[argn] */
	for(IdCmd=0; IdCmd<=3; IdCmd++)
	{
		if ((pArgv[IdCmd] == 0x00) || (pArgv[IdCmd] == '_'))
		{
			CmdEndOffset = IdCmd;
			break;
		} /* End of if */
	} /* End of for */

	memcpy(BufCmd, pArgv, IdCmd);
	Command = FT_ARG_ATOI(BufCmd);
	pArgv += IdCmd; /* skip command field */

	/* get Argc number */
	Argc = 0;
	pParam = pArgv;

	while(1)
	{
		if (*pParam == '_')
			Argc ++;
		/* End of if */

		if ((*pParam == 0x00) || (Argc > 20))
			break;
		/* End of if */

		pParam++;
	} /* End of while */

	pArgv++; /* skip _ points to arg1 */

	/* handle the command */
	switch(Command)
	{

#ifdef CONFIG_STA_SUPPORT
#ifdef FT_FUNC_SIMULATION
		case FT_RIC_CMD_SM_REQ_START:
			DBGPRINT(RT_DEBUG_TRACE, ("ft_iocl> (sm) Resource Request Start!\n"));
			FT_RIC_CMD_SimRscReqStart(pAd, Argc, pArgv);
			break;

		case FT_RIC_CMD_SM_REQ:
			DBGPRINT(RT_DEBUG_TRACE, ("ft_iocl> (sm) Resource Request!\n"));
			FT_RIC_CMD_SimRscReq(pAd, Argc, pArgv);
			break;

		case FT_RIC_CMD_SM_REQ_END:
			DBGPRINT(RT_DEBUG_TRACE, ("ft_iocl> (sm) Resource Request End!\n"));
			FT_RIC_CMD_SimRscReqEnd(pAd, Argc, pArgv);
			break;

		case FT_RIC_CMD_SM_REQ_RSP_LIST:
			DBGPRINT(RT_DEBUG_TRACE, ("ft_iocl> (sm) Resource Req/Rsp List!\n"));
			FT_RIC_CMD_SimRscReqRspList(pAd, Argc, pArgv);
			break;

		case FT_ROAMING_ACT:
			{
				PBSS_TABLE pRoamTab = &pAd->MlmeAux.RoamTab;
				UCHAR TargetAp[MAC_ADDR_LEN] = {0x00, 0x0c, 0x43, \
												0x28, 0x60, 0x10};
				ULONG Idx;

				BssTableInit(pRoamTab);
				Idx = BssTableSearch(&pAd->ScanTab, TargetAp,
								pAd->CommonCfg.Channel);
				if (BSS_NOT_FOUND != Idx)
				{
					NdisMoveMemory(&pRoamTab->BssEntry[pRoamTab->BssNr],
						&pAd->ScanTab.BssEntry[Idx], sizeof(BSS_ENTRY));
					pRoamTab->BssNr++;
				}
				else
					DBGPRINT(RT_DEBUG_ERROR,
						("Unkonw BssEntry (%ld):%02x:%02x:%02x:%02x:%02x:%02x\n",
						Idx, TargetAp[0], TargetAp[1], TargetAp[2], 
						TargetAp[3], TargetAp[4], TargetAp[5]));

				MlmeEnqueue(pAd, MLME_CNTL_STATE_MACHINE, MT2_MLME_ROAMING_REQ, 0, NULL, 0);
				RTMP_MLME_HANDLER(pAd);
			}
			break;
#endif /* FT_FUNC_SIMULATION */
#endif /* CONFIG_STA_SUPPORT */

		default: /* error command type */
			DBGPRINT(RT_DEBUG_TRACE,
						("ft_iocl> ERROR! No such command %d!\n", Command));
			return -EINVAL; /* input error */
	} /* End of switch */

	return TRUE;
} /* End of FT_Ioctl */

#endif /* DOT11R_FT_SUPPORT */

/* End of ft_iocl.c */
