/****************************************************************************
 * Ralink Tech Inc.
 * 4F, No. 2 Technology 5th Rd.
 * Science-based Industrial Park
 * Hsin-chu, Taiwan, R.O.C.
 * (c) Copyright 2002, Ralink Technology, Inc.
 *
 * All rights reserved. Ralink's source code is an unpublished work and the
 * use of a copyright notice does not imply otherwise. This source code
 * contains confidential trade secret material of Ralink Tech. Any attemp
 * or participation in deciphering, decoding, reverse engineering or in any
 * way altering the source code is stricitly prohibited, unless the prior
 * written consent of Ralink Technology, Inc. is obtained.
 ****************************************************************************

    Abstract:


 */

#ifdef DOT11R_FT_SUPPORT


#ifndef __FT_H
#define __FT_H

#include "link_list.h"
#include "ft_cmm.h"

#define IN
#define OUT
#define INOUT

/* Macro */
#define IS_FT_STA(__A) ((__A)->MdIeInfo.Len != 0)
#define IS_FT_ACTION_FRAME(__A) ((*(__A + 13) == 0x89)&&(*(__A + 14) == 0x0d))

/* ASCII to Integer */
#define FT_ARG_ATOI(__pArgv)			simple_strtol((PSTRING) __pArgv, 0, 10)

extern UINT32 FT_KDP_MemAllocNum, FT_KDP_MemFreeNum;
#define FT_MEM_ALLOC(__pAd, __pMem, __Size)	\
						os_alloc_mem(__pAd, (UCHAR **)(__pMem), __Size); \
						FT_KDP_MemAllocNum++;
#define FT_MEM_FREE(__pAd, __Mem)			\
						{ os_free_mem(__pAd, __Mem); \
						FT_KDP_MemFreeNum++; }

/*	atoi & atoh */
#define FT_ARG_ATOI(__pArgv)			simple_strtol((PSTRING) __pArgv, 0, 10)
#define FT_ARG_ATOH(__Buf, __Hex)		AtoH((PSTRING) __Buf, __Hex, 1)


/*
========================================================================
Routine Description:
	Initialize FT RIC Module.

Arguments:
	pAd				- WLAN control block pointer

Return Value:
	None

Note:
========================================================================
*/
VOID FT_RIC_Init(
	IN	PRTMP_ADAPTER		pAd);

/*
========================================================================
Routine Description:
	Release FT RIC Module.

Arguments:
	pAd				- WLAN control block pointer

Return Value:
	None

Note:
========================================================================
*/
VOID FT_RIC_Release(
	IN	PRTMP_ADAPTER		pAd);

/*
========================================================================
Routine Description:
	IO control handler for IEEE802.11r.

Arguments:
	pAd				- WLAN control block pointer
	pArgvIn			- the data flow information

Return Value:
	None

Note:
	All test commands are listed as follows:
		iwpriv ra0 set ft=[cmd id]_[arg1]_[arg2]_......_[argn]
		[cmd id] = xx, such as 00, 01, 02, 03, ...
========================================================================
*/
INT FT_Ioctl(
	IN	PRTMP_ADAPTER		pAd,
	IN	PSTRING				pArgvIn);

/*
========================================================================
Routine Description:
	FT insert MDIE to packet frame for IEEE802.11r.

Arguments:
	pAd				- WLAN control block pointer

Return Value:
	None

Note:

========================================================================
*/
VOID FT_InsertMdIE(
	IN PRTMP_ADAPTER pAd,
	OUT PUCHAR pFrameBuf,
	OUT PULONG pFrameLen,
	IN PUINT8 pMdId,
	IN FT_CAP_AND_POLICY FtCapPlc);

/*
========================================================================
Routine Description:
	FT configuration handler for IEEE802.11r.

Arguments:
	pAd				- WLAN control block pointer

Return Value:
	None

Note:

========================================================================
*/
 VOID FT_CfgInitial(
	IN PRTMP_ADAPTER pAd);

/*
========================================================================
Routine Description:
	FT function initialization for IEEE802.11r.
	FT_Init'll allocate tables, control blocks that FT needed.

Arguments:
	pAd				- WLAN control block pointer

Return Value:
	None

Note:

========================================================================
*/
VOID FT_Init(
	IN PRTMP_ADAPTER pAd);

/*
========================================================================
Routine Description:
	FT function release for IEEE802.11r.
	Free all tables, control blocks which FT_Init allocated.

Arguments:
	pAd				- WLAN control block pointer

Return Value:
	None

Note:

========================================================================
*/
VOID FT_Release(
	IN PRTMP_ADAPTER pAd);

/*
========================================================================
Routine Description:
	FT Peer Auth-Req handler for IEEE802.11r.

Arguments:
	pAd				- WLAN control block pointer

Return Value:
	None

Note:

========================================================================
*/
USHORT FT_AuthReqHandler(
	IN PRTMP_ADAPTER pAd,
	IN PMAC_TABLE_ENTRY pEntry,
	IN PFT_INFO pFtInfo,
	OUT PFT_INFO pFtInfoBuf);

/*
========================================================================
Routine Description:

Arguments:

Return Value:
	None

Note:

========================================================================
*/
VOID FT_EnqueueAuthReply(
	IN PRTMP_ADAPTER pAd,
	IN PHEADER_802_11 pRcvHdr,
	IN USHORT Alg,
    IN USHORT Seq, 
    IN USHORT StatusCode,
	IN PFT_MDIE_INFO pMdIeInfo,
	IN PFT_FTIE_INFO pFtIeInfo,
	IN PFT_RIC_INFO pRicInfo,
	IN PUCHAR pRsnIe,
	IN UCHAR RsnIeLen);

/*
========================================================================
Routine Description:
	FT Peer Auth-Confirm handler for IEEE802.11r.

Arguments:
	pAd				- WLAN control block pointer

Return Value:
	None

Note:

========================================================================
*/
USHORT FT_AuthConfirmHandler(
	IN PRTMP_ADAPTER pAd,
	IN PMAC_TABLE_ENTRY pEntry,
	IN PFT_INFO pFtInfo,
	OUT PFT_INFO pFtInfoBuf);

/*
========================================================================
Routine Description:
	FT Peer Association Request handler for IEEE802.11r.

Arguments:
	pAd				- WLAN control block pointer

Return Value:
	None

Note:

========================================================================
*/
USHORT FT_AssocReqHandler(
	IN PRTMP_ADAPTER pAd,
	IN BOOLEAN isReassoc,
	IN PFT_CFG pFtCfg,
    IN PMAC_TABLE_ENTRY pEntry,
	IN PFT_INFO			pPeer_FtInfo,
	OUT PFT_INFO	pFtInfoBuf);

/*
========================================================================
Routine Description:
	FT Peer Auth-Confirm handler for IEEE802.11r.

Arguments:
	pAd				- WLAN control block pointer

Return Value:
	None

Note:

========================================================================
*/
VOID FT_KDP_KeyResponse(
	IN	PRTMP_ADAPTER		pAd,
	IN	UCHAR				*pInfo,
	IN	INT32				InfoLen);

/*
========================================================================
Routine Description:
	FT Peer Resource Request handler for IEEE802.11r.

Arguments:
	pAd				- WLAN control block pointer

Return Value:
	None

Note:

========================================================================
*/
UINT32 FT_RIC_ResourceRequestHandle(
	IN	PRTMP_ADAPTER			pAd,
	IN	MAC_TABLE_ENTRY			*pCdb,
	IN	UCHAR					*pBufReq,
	IN	UINT32					ReqLen,
	OUT	UCHAR					*pBufRsp,
	OUT	UINT32					*pRspLen);


/*
========================================================================
Routine Description:
	FT Peer Resource Request handler for IEEE802.11r.

Arguments:
	pAd				- WLAN control block pointer

Return Value:
	None

Note:

========================================================================
*/
UINT32 BA_ResourceAllocate(
	IN PRTMP_ADAPTER pAd,
	IN MAC_TABLE_ENTRY *pMacEntry,
	IN UCHAR *pBufRscReq,
	OUT UCHAR *pBufRscRsp,
	OUT ULONG *pBufRspLen);

/*
========================================================================
Routine Description:
	FT Peer Auth-Confirm handler for IEEE802.11r.

Arguments:
	pAd				- WLAN control block pointer

Return Value:
	None

Note:

========================================================================
*/
VOID FT_InsertFTIE(
	IN PRTMP_ADAPTER pAd,
	OUT PUCHAR pFrameBuf,
	OUT PULONG pFrameLen,
	IN UINT8 Length,
	IN FT_MIC_CTR_FIELD MICCtr,
	IN PUINT8 pMic,
	IN PUINT8 pANonce,
	IN PUINT8 pSNonce);

/*
========================================================================
Routine Description:
	FT Peer Auth-Confirm handler for IEEE802.11r.

Arguments:
	pAd				- WLAN control block pointer

Return Value:
	None

Note:

========================================================================
*/
VOID FT_FTIE_InsertKhIdSubIE(
	IN PRTMP_ADAPTER pAd,
	OUT PUCHAR pFrameBuf,
	OUT PULONG pFrameLen,
	IN FT_SUB_ELEMENT_ID SubId,
	IN PUINT8 pKhId,
	IN UINT8 KhIdLen);

/*
========================================================================
Routine Description:
	FT Peer Auth-Confirm handler for IEEE802.11r.

Arguments:
	pAd				- WLAN control block pointer

Return Value:
	None

Note:

========================================================================
*/
VOID FT_FTIE_InsertGTKSubIE(
	IN PRTMP_ADAPTER pAd,
	IN 	PUCHAR 	pFrameBuf,
	OUT PULONG pFrameLen,
	IN 	PUINT8 	pGtkSubIe,
	IN 	UINT8 	GtkSubIe_len);

/*
========================================================================
Routine Description:
	FT Peer Auth-Confirm handler for IEEE802.11r.

Arguments:
	pAd				- WLAN control block pointer

Return Value:
	None

Note:

========================================================================
*/
VOID FT_InsertTimeoutIntervalIE(
	IN PRTMP_ADAPTER pAd,
	OUT PUCHAR pFrameBuf,
	OUT PULONG pFrameLen,
	IN FT_TIMEOUT_INTERVAL_TYPE Type,
	IN UINT32 TimeOutValue);

/*
========================================================================
Routine Description:

Arguments:

Return Value:

Note:

========================================================================
*/
VOID FT_R1khEntryTabInit(
	IN PRTMP_ADAPTER pAd);

/*
========================================================================
Routine Description:

Arguments:

Return Value:

Note:

========================================================================
*/
INT FT_R1khEntryInsert(
	IN PRTMP_ADAPTER pAd,
	IN PUINT8 pPmkR0Name,
	IN PUINT8 pPmkR1Name,
	IN PUINT8 pPmkR1Key,
	IN PUINT8 pPairwisChipher,
	IN PUINT8 pAkmSuite,
	IN UINT32 KeyLifeTime,
	IN UINT32 RassocDeadline,
	IN PUINT8 pR0khId,
	IN UINT8 R0khIdLen,
	IN PUINT8 pStaMac);

/*
========================================================================
Routine Description:

Arguments:

Return Value:

Note:

========================================================================
*/
VOID FT_R1khEntryDelete(
	IN PRTMP_ADAPTER pAd,
	IN PFT_R1HK_ENTRY pEntry);

/*
========================================================================
Routine Description:

Arguments:

Return Value:

Note:

========================================================================
*/
VOID FT_R1khEntryTabDestroy(
	IN PRTMP_ADAPTER pAd);

/*
========================================================================
Routine Description:

Arguments:

Return Value:

Note:

========================================================================
*/
PFT_R1HK_ENTRY FT_R1khEntryTabLookup(
	IN PRTMP_ADAPTER pAd,
	IN PUINT8 pPMKR1Name);

/*
========================================================================
Routine Description:

Arguments:

Return Value:

Note:

========================================================================
*/
VOID FT_FillMdIeInfo(
	PEID_STRUCT eid_ptr,
	PFT_MDIE_INFO pMdIeInfo);

/*
========================================================================
Routine Description:

Arguments:

Return Value:

Note:

========================================================================
*/
VOID FT_FillFtIeInfo(
	PEID_STRUCT eid_ptr,
	PFT_FTIE_INFO pFtIeInfo);

/*
========================================================================
Routine Description:

Arguments:

Return Value:

Note:

========================================================================
*/
VOID FT_FtAction(
	IN PRTMP_ADAPTER pAd, 
	IN MLME_QUEUE_ELEM *Elem);

/*
========================================================================
Routine Description:

Arguments:

Return Value:

Note:

========================================================================
*/
VOID FT_RrbHandler(
	IN PRTMP_ADAPTER pAd,
	IN PUCHAR pPktSrc,
	IN INT32 PktLen);

/*
========================================================================
Routine Description:

Arguments:

Return Value:

Note:

========================================================================
*/
VOID FT_R1KHInfoMaintenance(
	IN PRTMP_ADAPTER pAd);

/*
========================================================================
Routine Description:
	Display all R0KH information.
 
Arguments:
	pAd				- WLAN control block pointer
	*pArgv			- input parameters

Return Value:
	TRUE

Note:
========================================================================
*/
INT FT_KDP_CMD_R0KH_InfoShow(
	IN	PRTMP_ADAPTER		pAd,
	IN	PSTRING				pArgv);

VOID FT_MakeFtActFrame(
	IN PRTMP_ADAPTER pAd,
	OUT PUCHAR pFrameBuf,
	OUT PULONG pFrameLen,
	IN UINT8 ActType,
	IN PUCHAR pStaMac,
	IN PUCHAR pTargetApMac,
	IN UINT16 StatusCode,
	IN PFT_INFO pFtInfo);

VOID FT_DerivePMKR0(
	IN	PUINT8	xxkey,
	IN	INT		xxkey_len,
	IN	PUINT8	ssid,
	IN	INT		ssid_len,
	IN	PUINT8	mdid,
	IN	PUINT8 	r0khid,
	IN	INT		r0khid_len,
	IN	PUINT8	s0khid,
	OUT	PUINT8	pmkr0,
	OUT	PUINT8	pmkr0_name);

VOID FT_DerivePMKR1Name(
	IN	PUINT8	pmkr0_name,
	IN	PUINT8 	r1khid,
	IN	PUINT8	s1khid,
	OUT	PUINT8	pmkr1_name);

VOID FT_DerivePMKR1(
	IN	PUINT8	pmkr0,
	IN	PUINT8	pmkr0_name,
	IN	PUINT8 	r1khid,
	IN	PUINT8	s1khid,
	OUT	PUINT8	pmkr1,
	OUT	PUINT8	pmkr1_name);

VOID FT_DerivePTK(
	IN	PUINT8	pmkr1,
	IN	PUINT8	pmkr1_name,
	IN	PUINT8 	a_nonce,
	IN	PUINT8 	s_nonce,
	IN	PUINT8 	bssid,
	IN	PUINT8 	sta_mac,
	IN	UINT	key_len,
	OUT	PUINT8	ptk,
	OUT	PUINT8	ptk_name);

VOID	FT_CalculateMIC(
	IN	PUINT8		sta_addr,	
	IN	PUINT8		ap_addr,
	IN	PUINT8		kck,
	IN	UINT8		seq,
	IN  PUINT8		rsnie,
	IN	UINT8		rsnie_len,
	IN	PUINT8		mdie,
	IN	UINT8		mdie_len,
	IN	PUINT8		ftie,
	IN	UINT8		ftie_len,
	IN	PUINT8		ric,
	IN	UINT8		ric_len,
	OUT PUINT8		mic);

#ifdef CONFIG_STA_SUPPORT
void FT_OTA_AuthStateMachineInit(
    IN PRTMP_ADAPTER pAd, 
    IN STATE_MACHINE *Sm, 
    OUT STATE_MACHINE_FUNC Trans[]);

VOID FT_OTA_MlmeAuthReqAction(
    IN PRTMP_ADAPTER pAd, 
    IN MLME_QUEUE_ELEM *Elem);

VOID FT_OTA_PeerAuthRspAction(
    IN PRTMP_ADAPTER pAd, 
    IN MLME_QUEUE_ELEM *Elem);

VOID FT_OTA_PeerAuthAckAction(
    IN PRTMP_ADAPTER pAd, 
    IN MLME_QUEUE_ELEM *Elem);

VOID FT_OTA_InvalidStateWhenAuth(
    IN PRTMP_ADAPTER pAd, 
    IN MLME_QUEUE_ELEM *Elem);

VOID FT_OTA_AuthParmFill(
	IN PRTMP_ADAPTER pAd, 
	IN OUT MLME_FT_OTA_AUTH_REQ_STRUCT *pFtOtaAuthReq, 
	IN PUCHAR 	pAddr, 
	IN USHORT 	Alg,
	IN PDOT11R_CMN_STRUC	pCmmDot11rCfg);

VOID FT_FTIeParse(
	IN		UINT8		FtIeLen,
	IN		PFT_FTIE	pFtIe,
	OUT		PUCHAR		pR1KH_Id,
	OUT		UCHAR		*GTKLen,
	OUT		PUCHAR		pGTK,
	OUT		UCHAR		*R0KH_IdLen,
	OUT		PUCHAR		pR0KH_Id);

void FT_OTD_StateMachineInit(
    IN PRTMP_ADAPTER pAd, 
    IN STATE_MACHINE *Sm, 
    OUT STATE_MACHINE_FUNC Trans[]);

VOID FT_OTD_ReqAction(
    IN PRTMP_ADAPTER pAd, 
    IN MLME_QUEUE_ELEM *Elem);

VOID FT_OTD_PeerRspAtSeq2Action(
	IN PRTMP_ADAPTER pAd, 
	IN MLME_QUEUE_ELEM *Elem);

VOID FT_OTD_PeerAckAtSeq4Action(
	IN PRTMP_ADAPTER pAd, 
	IN MLME_QUEUE_ELEM *Elem);

VOID FT_OTD_InvalidStateWhenFt(
	IN PRTMP_ADAPTER pAd, 
	IN MLME_QUEUE_ELEM *Elem);

VOID FT_OTD_ActParmFill(
	IN PRTMP_ADAPTER pAd, 
	IN OUT MLME_FT_REQ_STRUCT *FtReq, 
	IN PUCHAR pAddr, 
	IN NDIS_802_11_AUTHENTICATION_MODE	AuthMode,
	IN PFT_MDIE_INFO	FtMdieInfo,
	IN PFT_FTIE_INFO	FtFtieInfo,
	IN UCHAR 			VarIeLen,
	IN PUCHAR 			pVarIe);

BOOLEAN FT_CheckForRoaming(
	IN	PRTMP_ADAPTER	pAd);

BOOLEAN	FT_GetMDIE(
	IN  PNDIS_802_11_VARIABLE_IEs	pVIE,
	IN  USHORT		LengthVIE,
	OUT FT_MDIE_INFO				*pMdIeInfo);

BOOLEAN FT_ExtractGTKSubIe(
	IN	PRTMP_ADAPTER 		pAd,
	IN 	PMAC_TABLE_ENTRY 	pEntry,
	IN	PFT_FTIE_INFO		pFtInfo);

VOID FT_ConstructAuthReqInRsn(
	IN 	PRTMP_ADAPTER 	pAd,
	IN 	PUCHAR 			pFrameBuf,
	OUT PULONG 			pFrameLen);

/*
========================================================================
Routine Description:
	Start to do resource request for other APs.

Arguments:
	pAd				- WLAN control block pointer

Return Value:
	TRUE			- successfully
	FALSE			- no any resource is needed to request

Note:
	1. After the function is called, no any new TSPEC can be issued from us.
========================================================================
*/
BOOLEAN FT_RIC_ResourceRequestStart(
	IN	PRTMP_ADAPTER			pAd);

/*
========================================================================
Routine Description:
	End to do resource request for other APs.

Arguments:
	pAd				- WLAN control block pointer
	*pApMac			- the new AP MAC

Return Value:
	None

Note:
	1. After the function is called, no any new TSPEC can be issued from us.
========================================================================
*/
VOID FT_RIC_ResourceRequestEnd(
	IN	PRTMP_ADAPTER			pAd,
	IN	UCHAR					*pApMac);

/*
========================================================================
Routine Description:
	Issue resource requests.

Arguments:
	pAd				- WLAN control block pointer
	*pApMac			- the AP MAC
	*pBufReq		- the request packet buffer
	ReqMaxLen		- the maximum remain length of request packet buffer

Return Value:
	filled element length

Note:
	1. Same resource type for all resource descriptors in the RDIE.
	2. Suppose RDIEs are continual.
	3. If pDescpBlk != NULL, skip current TSPEC.

	4. 11A.11.3 Creation and handling of a resource request (11r D9.0)
		(1) In using TSPECs for requesting QoS resources, the TSPECs in the
			request need not belong to only active Traffic Streams;
		(2) The non-AP STA can send TSPECs for any Traffic Stream that it
			intends to use after the transition, and request the same resources
			that would be requested by a later ADDTS exchange.

		==> We do NOT support the function.

	5. Resource request usage for QSTA:
		Case 1:
		(1) Scan or get neighbor report of other QAPs;
		(2) Maybe signal is bad with current AP and good for other QAPs;

		-- FT_RIC_ResourceRequestStart()
			No new TSPEC can be issued.

		-- FT_RIC_ResourceRequest()
			Build current TSPEC to the QAP1.

		(3) FT confirm to QAP1;

		-- FT_RIC_ResourceResponseHandle() for QAP1.

		(4) Handle FT ACK from QAP1;

		(6) a. Signal is still bad so determining to reassociate a QAP;
			b. Maybe signal is good again with current QAP, no roaming is needed;

		-- FT_RIC_ResourceRequestEnd(ptr to TSPEC status)

		Case 2:
		(1) Scan or get neighbor report of other QAPs;
		(2) Maybe signal is bad with current AP and good for other QAPs;

		-- FT_RIC_ResourceRequestStart()
			No new TSPEC can be issued.

		-- FT_RIC_ResourceRequest()
			Build current TSPEC to the QAP1.

		(3) FT confirm to QAP1;

		-- FT_RIC_ResourceRequest()
			Build current TSPEC to the QAP2.

		(4) FT confirm to QAP2;

		-- (get success percentage) FT_RIC_ResourceResponseHandle(ptr to TSPEC status) for QAP1.
		-- (get success percentage) FT_RIC_ResourceResponseHandle(ptr to TSPEC status) for QAP2.

		(5) Handle FT ACK from different QAPs;
		(6) a. Signal is still bad so determining to reassociate a QAP;
			b. Maybe signal is good again with current QAP, no roaming is needed;
			c. Select the best resource allocation;

		-- FT_RIC_ResourceRequestEnd(ptr to TSPEC status)
			New TSPECs can be issued.
========================================================================
*/
UINT32 FT_RIC_ResourceRequest(
	IN	PRTMP_ADAPTER			pAd,
	IN	UCHAR					*pApMac,
	IN	UCHAR					*pBufReq,
	IN	UINT32					ReqMaxLen);

/*
========================================================================
Routine Description:
	Handle resource responses.

Arguments:
	pAd				- WLAN control block pointer
	*pApMac			- the AP MAC
	*pBufRsp		- the response packet buffer
	RspLen			- the maximum remain length of response packet buffer
	*pRspStatus		- the status report

Return Value:
	handled length

Note:
	1. Same resource type for all resource descriptors in the RDIE.
	2. Suppose RDIEs are continual.
========================================================================
*/
UINT32 FT_RIC_ResourceResponseHandle(
	IN	PRTMP_ADAPTER			pAd,
	IN	UCHAR					*pApMac,
	IN	UCHAR					*pBufRsp,
	IN	UINT32					RspLen,
	OUT	FT_RIC_STATUS			*pRspStatus);
#endif /* CONFIG_STA_SUPPORT */

void FT_rtmp_read_parameters_from_file(
	IN PRTMP_ADAPTER pAd,
	PSTRING tmpbuf,
	PSTRING pBuffer);

INT Set_FT_Enable(
	IN	PRTMP_ADAPTER	pAd,
	IN	PSTRING			arg);

INT Set_FT_Mdid(
	IN	PRTMP_ADAPTER	pAd,
	IN	PSTRING			arg);

INT Set_FT_R0khid(
	IN	PRTMP_ADAPTER	pAd,
	IN	PSTRING			arg);

INT Set_FT_RIC(
	IN	PRTMP_ADAPTER	pAd,
	IN	PSTRING			arg);

INT Set_FT_OTD(
	IN	PRTMP_ADAPTER	pAd,
	IN	PSTRING			arg);

INT	Show_FTConfig_Proc(
	IN	PRTMP_ADAPTER	pAd, 
	IN	PSTRING			arg);

#endif /* __FT_H */
#endif /* DOT11R_FT_SUPPORT */

